﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System.Reflection;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

using GE.Manager;

namespace GE.Gui
{
    /// <summary>
    /// A text button widget.
    /// </summary>
    class WButton : Widget
    {
        /// <summary>
        /// Position.
        /// </summary>
        protected Vector2 m_position;

        /// <summary>
        /// Image.
        /// </summary>
        protected WImage m_image;

        /// <summary>
        /// Image when focused.
        /// </summary>
        protected WImage m_focusImage;

        /// <summary>
        /// Text.
        /// </summary>
        protected WText m_text;

        /// <summary>
        /// the button focus state.
        /// </summary>
        protected bool m_isFocused;

        /// <summary>
        /// Callback to invoke when clicked.
        /// </summary>
        protected MethodInfo m_clickCallback;

        /// <summary>
        /// Callback to invoke when focused.
        /// </summary>
        protected MethodInfo m_focusCallback;

        /// <summary>
        /// The focus state of the button.
        /// </summary>
        public bool IsFocused
        {
            get
            {
                return m_isFocused;
            }
            set
            {
                m_isFocused = value;
                if (value == true)
                {
                    if (m_focusCallback != null)
                        m_focusCallback.Invoke(m_owner, new object[] { });
                }
            }
        }

        /// <summary>
        /// Text.
        /// </summary>
        public string Text
        {
            get
            {
                return m_text.Text;
            }
            set
            {
                m_text.Text = value;
            }
        }

        public Vector2 Position
        {
            get
            {
                return m_position;
            }
        }

        /// <summary>
        /// Callback to invoke when clicked.
        /// </summary>
        public MethodInfo OnClick
        {
            set
            {
                m_clickCallback = value;
            }
        }

        /// <summary>
        /// Callback to invoke when focused.
        /// </summary>
        public MethodInfo OnFocus
        {
            set
            {
                m_focusCallback = value;
            }
        }

        /// <summary>
        /// Empty Constructor
        /// </summary>
        protected WButton()
        {
        }

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="owner">owner</param>
        /// <param name="text">test</param>
        /// <param name="color">text color</param>
        /// <param name="position">position</param>
        public WButton(Window owner, string text, Color color, Vector2 position)
        {
            m_owner = owner;
            m_position = position;
            m_isFocused = false;
            m_clickCallback = null;
            m_focusCallback = null;
            m_image = new WImage("Widget\\button_256_64", new Vector2(0f, 0f));
            m_focusImage = new WImage("Widget\\button_256_64_focus", new Vector2(0f, 0f));
            m_text = new WText(FontType.MenuButton, text, new Vector2(18f), color);
        }

        /// <summary>
        /// Render the widget.
        /// </summary>
        /// <param name="offset">position offset</param>
        public override void render(Vector2 offset)
        {
            base.render(offset);
            if (!m_isFocused)
                m_image.render(offset + m_position);
            else
                m_focusImage.render(offset + m_position);
            m_text.render(offset + m_position);
        }

        /// <summary>
        /// Click the widget.
        /// </summary>
        public void click()
        {
            if(m_clickCallback != null)
                m_clickCallback.Invoke(m_owner, new object[] {});
        }
    }
}
